import { BUTTON_COLOR, BROWNISH_GREY, GREYISH_BROWN } from 'constants/colors';

const styles = () => ({
    container: {
        height: '100%',
        width: '100%',
        display: 'flex',
        flexDirection: 'column',
        alignItems: 'center',
        alignContent: 'center'
    },
    innerContainer: {
        display: 'flex',
        flexDirection: 'column',
        alignItems: 'center',
        width: '100%',
        marginTop: 121
    },
    imageContainer: {
        width: 116,
        height: 116,
        position: 'relative'
    },
    badgeImage: {
        position: 'absolute',
        right: 0,
        bottom: 0
    },
    title: {
        fontFamily: 'Roboto-Condensed',
        fontSize: 22,
        fontWeight: 'bold',
        fontStyle: 'normal',
        lineHeight: 1.27,
        letterSpacing: 0.68,
        marginTop: 46,
        color: GREYISH_BROWN
    },
    subtitle: {
        marginTop: 12,
        color: BROWNISH_GREY,
        fontFamily: 'Lato',
        fontSize: 16,
        fontWeight: 'normal',
        fontStretch: 'normal',
        fontStyle: 'normal',
        lineHeight: 1.5,
        letterSpacing: 'normal'
    },
    buttonContainer: {
        display: 'flex',
        flexDirection: 'row',
        marginTop: 28
    },
    help: {
        opacity: '0.8 !important',
        fontFamily:
            'Lato, Roboto, Arial, Helvetica, Helvetica Neue, serif !important',
        fontSize: '16px !important',
        marginTop: 28,
        color: GREYISH_BROWN,
        lineHeight: 1.5,

        '& a': {
            color: `${BUTTON_COLOR} !important`
        }
    },
    tryAgain: {
        marginRight: 24
    }
});

export default styles;
